//
//  MCOPAbstractPane.h
//  MCApplication
//
//  Created by Ali Lalani on 1/26/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCSearchField,MCArrayController,MCTableView,MCPFetchSpecification,MCObjectPicker;
@interface MCOPAbstractPane : NSView{
	IBOutlet MCSearchField       *searchField;	
	IBOutlet MCArrayController   *ac;
	IBOutlet MCTableView         *tv;
	IBOutlet NSProgressIndicator *progress;
	
	MCObjectPicker *parentController;
	
	NSDictionary             *_configuration;
	MCPFetchSpecification    *_fetchSpec;
}
- (id)preferredFirstResponder;

- (BOOL)hasBatches;

- (void)configureWithDictionary:(NSDictionary *)conf;

- (id)qualifierForFetchSpec:(MCPFetchSpecification *)spec;

- (IBAction)tableviewDidDoubleClick:(id)sender;
- (IBAction)search:(id)sender;
- (IBAction)fetchNextBatch:(id)sender;
- (IBAction)fetchPreviousBatch:(id)sender;

- (NSDictionary *)configuration;
- (void)setConfiguration:(NSDictionary *)aConfiguration;

- (MCPFetchSpecification *)fetchSpec;
- (void)setFetchSpec:(MCPFetchSpecification *)aFetchSpec;

- (MCArrayController *)arrayController;

- (void)setParentController:(MCObjectPicker *)aParentController;
- (MCObjectPicker *)parentController;
@end
